/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.ponder.scenes.highLogistics;

import com.mojang.serialization.DynamicOps;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.ponder.CreateSceneBuilder;
import com.zurrtum.create.client.infrastructure.ponder.scenes.highLogistics.PonderHilo;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.zurrtum.create.content.kinetics.mixer.MechanicalMixerBlockEntity;
import com.zurrtum.create.content.kinetics.saw.SawBlockEntity;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.zurrtum.create.content.logistics.factoryBoard.PanelSlot;
import com.zurrtum.create.content.logistics.factoryBoard.ServerFactoryPanelBehaviour;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.content.processing.recipe.ProcessingInventory;
import com.zurrtum.create.content.redstone.link.RedstoneLinkBlock;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2769;
import net.minecraft.class_6903;

@Environment(value=EnvType.CLIENT)
public class FactoryGaugeScenes {
    public static void restocker(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("factory_gauge_restocker", "Restocking with Factory Gauges");
        scene.configureBasePlate(0, 0, 7);
        scene.scaleSceneView(0.925f);
        scene.setSceneOffsetY(-0.5f);
        scene.showBasePlate();
        Selection vault = util.select().fromTo(5, 1, 4, 6, 3, 6);
        Selection packager = util.select().fromTo(4, 1, 5, 4, 2, 5);
        class_2338 pack = util.grid().at(4, 2, 5);
        class_2338 link = util.grid().at(4, 3, 5);
        Selection linkS = util.select().position(4, 3, 5);
        Selection funnel = util.select().position(3, 2, 5);
        Selection funnel2 = util.select().position(1, 2, 2);
        Selection belt1 = util.select().fromTo(1, 1, 2, 1, 1, 6).add(util.select().fromTo(2, 1, 6, 2, 1, 7));
        Selection largeCog = util.select().position(1, 0, 7);
        Selection belt2 = util.select().fromTo(3, 1, 5, 2, 1, 5);
        Selection chest = util.select().fromTo(3, 2, 1, 2, 2, 1);
        Selection chestScaff = util.select().fromTo(3, 1, 1, 2, 1, 1);
        Selection packScaff = util.select().position(1, 1, 1);
        class_2338 pack2 = util.grid().at(1, 2, 1);
        Selection pack2S = util.select().position(1, 2, 1);
        class_2338 gauge = util.grid().at(1, 2, 0);
        Selection gaugeS = util.select().position(1, 2, 0);
        scene.idle(10);
        ElementLink<WorldSectionElement> linkL = scene.world().showIndependentSection(linkS, class_2350.field_11033);
        scene.world().moveSection(linkL, util.vector().of(0.0, -2.0, 0.0), 0);
        ElementLink<WorldSectionElement> chestL = scene.world().showIndependentSection(chest, class_2350.field_11033);
        scene.world().moveSection(chestL, util.vector().of(0.0, -1.0, 0.0), 0);
        scene.idle(5);
        scene.world().showSectionAndMerge(pack2S, class_2350.field_11034, chestL);
        scene.idle(15);
        class_1799 linkItem = AllItems.FACTORY_GAUGE.method_7854();
        scene.overlay().showControls(util.vector().topOf(link.method_10087(2)), Pointing.DOWN, 50).rightClick().withItem(linkItem);
        scene.idle(5);
        class_238 bb1 = new class_238(link.method_10087(2));
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.BLUE, link, bb1.method_1011(0.45), 10);
        scene.idle(1);
        bb1 = bb1.method_1011(0.0625).method_1002(0.0, 0.5, 0.0);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.BLUE, link, bb1, 50);
        scene.idle(26);
        scene.overlay().showText(100).text("Right-click a Stock link before placement to connect to its network").attachKeyFrame().colored(PonderPalette.BLUE).placeNearTarget().pointAt(util.vector().centerOf(link.method_10087(2)));
        scene.idle(60);
        scene.world().showSectionAndMerge(gaugeS, class_2350.field_11035, chestL);
        scene.idle(50);
        class_243 gaugeMiddle = util.vector().of(1.25, 1.75, 1.0);
        scene.overlay().showText(100).text("When placed on a packager, factory gauges can monitor items inside the inventory").attachKeyFrame().placeNearTarget().pointAt(gaugeMiddle);
        scene.idle(30);
        scene.overlay().showOutline(PonderPalette.BLUE, gauge, util.select().fromTo(3, 1, 1, 2, 1, 1), 70);
        scene.idle(80);
        class_1799 monitorItem = new class_1799((class_1935)class_1802.field_8665);
        scene.overlay().showControls(gaugeMiddle, Pointing.DOWN, 50).withItem(monitorItem).rightClick();
        scene.idle(7);
        FactoryGaugeScenes.setPanelItem(builder, gauge, PanelSlot.TOP_RIGHT, monitorItem);
        scene.world().modifyBlockEntity(gauge, FactoryPanelBlockEntity.class, be -> {
            ServerFactoryPanelBehaviour pb = be.panels.get((Object)PanelSlot.BOTTOM_LEFT);
            pb.setFilter(monitorItem);
        });
        scene.overlay().showText(80).text("Right-click it with the item that should be monitored").attachKeyFrame().placeNearTarget().pointAt(gaugeMiddle);
        scene.idle(90);
        scene.overlay().showOutline(PonderPalette.BLUE, gauge, util.select().fromTo(3, 1, 1, 2, 1, 1), 70);
        scene.overlay().showText(70).text("It will now display the amount present in the inventory").colored(PonderPalette.BLUE).placeNearTarget().pointAt(gaugeMiddle);
        scene.idle(80);
        scene.world().moveSection(linkL, util.vector().of(0.0, 2.25, 0.0), 15);
        scene.idle(5);
        scene.idle(8);
        scene.world().showSection(vault, class_2350.field_11043);
        scene.idle(5);
        scene.world().showSection(packager, class_2350.field_11034);
        scene.idle(2);
        scene.world().moveSection(linkL, util.vector().of(0.0, -0.25, 0.0), 10);
        scene.idle(10);
        scene.overlay().showText(90).text("The gauge can refill this inventory from the logistics network").attachKeyFrame().placeNearTarget().pointAt(util.vector().of(3.0, 2.0, 1.5));
        scene.idle(100);
        scene.overlay().showControls(gaugeMiddle, Pointing.DOWN, 50).rightClick();
        scene.idle(7);
        class_238 boundingBox = new class_238(gaugeMiddle, gaugeMiddle).method_1009(0.19, 0.19, 0.0);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.BLUE, gauge, boundingBox, 150);
        scene.overlay().showText(70).text("Right-click it again to open its configuration UI").attachKeyFrame().colored(PonderPalette.BLUE).placeNearTarget().pointAt(gaugeMiddle);
        scene.idle(80);
        scene.overlay().showText(70).text("Set an address that should be used for the requested items").attachKeyFrame().placeNearTarget().pointAt(gaugeMiddle);
        scene.idle(80);
        scene.world().moveSection(chestL, util.vector().of(0.0, 1.0, 0.0), 10);
        scene.idle(10);
        scene.world().showSection(chestScaff, class_2350.field_11043);
        scene.world().showSection(packScaff, class_2350.field_11043);
        scene.idle(10);
        scene.world().showSection(largeCog, class_2350.field_11036);
        scene.world().showSection(belt1, class_2350.field_11034);
        scene.idle(5);
        scene.world().showSection(belt2, class_2350.field_11035);
        scene.idle(15);
        gaugeMiddle = gaugeMiddle.method_1031(0.0, 1.0, 0.0);
        scene.overlay().showControls(gaugeMiddle, Pointing.DOWN, 100).rightClick();
        scene.idle(7);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, gauge, boundingBox.method_989(0.0, 1.0, 0.0), 100);
        scene.overlay().showText(100).text("The target amount to maintain can now be set by holding Right-click on the gauge").attachKeyFrame().colored(PonderPalette.GREEN).placeNearTarget().pointAt(gaugeMiddle);
        scene.idle(40);
        FactoryGaugeScenes.setPanelNotSatisfied(builder, gauge, PanelSlot.TOP_RIGHT);
        scene.idle(70);
        scene.overlay().showText(70).text("Whenever the chest has fewer items than this amount...").attachKeyFrame().placeNearTarget().pointAt(util.vector().of(3.0, 3.0, 1.5));
        scene.idle(50);
        PonderHilo.linkEffect(scene, link);
        class_1799 box = PackageItem.containing(List.of());
        PonderHilo.packagerCreate(scene, pack, box);
        scene.idle(30);
        scene.overlay().showText(70).text("...the logistics network sends more, with the specified address").attachKeyFrame().placeNearTarget().pointAt(util.vector().of(4.0, 2.5, 5.5));
        scene.idle(50);
        scene.world().showSection(funnel, class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(funnel2, class_2350.field_11033);
        scene.idle(5);
        scene.world().createItemOnBelt(util.grid().at(3, 1, 5), class_2350.field_11034, box);
        PonderHilo.packagerClear(scene, pack);
        scene.idle(40);
        scene.overlay().showText(70).text("From there, they can be routed to the packager").placeNearTarget().pointAt(util.vector().of(1.0, 2.5, 3.5));
        scene.idle(30);
        scene.world().removeItemsFromBelt(util.grid().at(1, 1, 2));
        PonderHilo.packagerUnpack(scene, pack2, box);
        scene.idle(15);
        FactoryGaugeScenes.setPanelSatisfied(builder, gauge, PanelSlot.TOP_RIGHT);
    }

    public static void recipe(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("factory_gauge_recipe", "Automated Recipes with Factory Gauges");
        scene.configureBasePlate(0, 0, 9);
        scene.scaleSceneView(0.925f);
        scene.setSceneOffsetY(-0.5f);
        Selection fakeFloor = util.select().fromTo(8, 6, 0, 0, 6, 8);
        Selection belt1 = util.select().fromTo(1, 0, 7, 1, 0, 2);
        Selection belt2 = util.select().fromTo(1, 0, 1, 3, 0, 1);
        Selection saw = util.select().position(4, 0, 1);
        Selection belt3 = util.select().fromTo(5, 0, 1, 6, 0, 1);
        Selection belt4 = util.select().fromTo(7, 0, 7, 7, 0, 5);
        Selection funnel1 = util.select().position(1, 1, 7);
        Selection funnel2 = util.select().position(6, 1, 1);
        Selection funnel3 = util.select().position(7, 1, 5);
        Selection pack2S = util.select().fromTo(7, 1, 7, 6, 1, 7);
        Selection basin = util.select().position(7, 1, 1);
        Selection mixer = util.select().fromTo(7, 3, 1, 9, 3, 1).add(util.select().fromTo(9, 2, 1, 9, 0, 1));
        Selection basinOut = util.select().fromTo(7, 0, 2, 7, 1, 2);
        Selection barrelAndPackager = util.select().fromTo(7, 2, 4, 7, 1, 3);
        class_2338 pack = util.grid().at(2, 1, 7);
        Selection packS = util.select().fromTo(2, 1, 7, 2, 2, 7);
        class_2338 link = util.grid().at(2, 2, 7);
        Selection vault = util.select().fromTo(5, 2, 7, 3, 1, 6);
        Selection scaff1 = util.select().fromTo(5, 1, 4, 3, 1, 4);
        Selection scaff2 = util.select().position(2, 1, 4);
        Selection board1 = util.select().fromTo(5, 2, 4, 3, 3, 4);
        Selection board2 = util.select().fromTo(6, 5, 4, 2, 2, 4).substract(board1);
        class_2338 alloyG = util.grid().at(3, 3, 3);
        class_2338 andeG = util.grid().at(4, 3, 3);
        class_2338 nuggG = util.grid().at(4, 2, 3);
        class_2338 ironG = util.grid().at(5, 2, 3);
        class_2338 rawIronG = util.grid().at(6, 3, 3);
        class_2338 dioriteG = util.grid().at(5, 3, 3);
        class_2338 planksG = util.grid().at(3, 4, 3);
        class_2338 logsG = util.grid().at(4, 4, 3);
        class_2338 cogG = util.grid().at(2, 2, 3);
        class_2338 quartzG = util.grid().at(6, 4, 3);
        class_2338 cobbleG = util.grid().at(5, 4, 3);
        ElementLink<WorldSectionElement> floorL = scene.world().showIndependentSection(fakeFloor, class_2350.field_11036);
        scene.world().moveSection(floorL, util.vector().of(0.0, -6.0, 0.0), 0);
        scene.idle(10);
        FactoryGaugeScenes.setPanelVisible(builder, alloyG, PanelSlot.TOP_RIGHT, false);
        FactoryGaugeScenes.setPanelPassive(builder, alloyG, PanelSlot.BOTTOM_LEFT);
        FactoryGaugeScenes.removePanelConnections(builder, alloyG, PanelSlot.BOTTOM_LEFT);
        FactoryGaugeScenes.setPanelItem(builder, alloyG, PanelSlot.BOTTOM_LEFT, class_1799.field_8037);
        scene.world().showSection(scaff1, class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(board1, class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().position(alloyG), class_2350.field_11035);
        scene.idle(25);
        class_243 panelM = util.vector().of(3.75, 3.25, 4.0);
        scene.overlay().showText(60).text("Whenever gauges are not placed on a packager...").attachKeyFrame().placeNearTarget().pointAt(panelM);
        scene.idle(50);
        scene.world().showSection(vault, class_2350.field_11043);
        scene.idle(5);
        scene.world().showSection(packS, class_2350.field_11034);
        scene.idle(15);
        scene.overlay().showOutlineWithText(vault, 100).text("They will instead monitor stock levels of all linked inventories").attachKeyFrame().colored(PonderPalette.BLUE).placeNearTarget().pointAt(util.vector().of(4.0, 3.0, 7.0));
        scene.idle(110);
        class_1799 monitorItem = AllItems.ANDESITE_ALLOY.method_7854();
        scene.overlay().showControls(panelM, Pointing.DOWN, 50).withItem(monitorItem).rightClick();
        scene.idle(7);
        FactoryGaugeScenes.setPanelItem(builder, alloyG, PanelSlot.BOTTOM_LEFT, monitorItem);
        scene.overlay().showText(80).text("Right-click it with the item that should be monitored").attachKeyFrame().placeNearTarget().pointAt(panelM);
        scene.idle(90);
        scene.overlay().showOutlineWithText(vault, 100).text("It will now display the total amount present on the network").colored(PonderPalette.BLUE).placeNearTarget().pointAt(panelM);
        scene.idle(100);
        scene.world().showSection(mixer, class_2350.field_11039);
        scene.world().showSection(basin, class_2350.field_11039);
        scene.idle(20);
        scene.overlay().showText(110).text("The gauge can replenish stock levels by sending other items to be processed").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(7, 1, 1), class_2350.field_11039));
        scene.idle(120);
        FactoryGaugeScenes.setPanelPassive(builder, andeG, PanelSlot.BOTTOM_LEFT);
        FactoryGaugeScenes.removePanelConnections(builder, andeG, PanelSlot.BOTTOM_LEFT);
        FactoryGaugeScenes.setPanelPassive(builder, nuggG, PanelSlot.TOP_LEFT);
        FactoryGaugeScenes.removePanelConnections(builder, nuggG, PanelSlot.TOP_LEFT);
        scene.world().showSection(util.select().position(andeG), class_2350.field_11035);
        scene.idle(5);
        scene.world().showSection(util.select().position(nuggG), class_2350.field_11035);
        scene.idle(20);
        scene.overlay().showText(70).text("First, add the required ingredients as new factory gauges").attachKeyFrame().placeNearTarget().pointAt(panelM.method_1031(1.0, -0.5, 0.0));
        scene.idle(80);
        scene.world().multiplyKineticSpeed(util.select().fromTo(6, 0, 1, 1, 0, 7), 2.0f);
        scene.overlay().showControls(panelM, Pointing.DOWN, 40).rightClick();
        scene.idle(7);
        class_238 boundingBox = new class_238(panelM, panelM).method_1009(0.19, 0.19, 0.0);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.BLUE, alloyG, boundingBox, 100);
        scene.overlay().showText(70).text("From the target's UI, new connections can be made").attachKeyFrame().placeNearTarget().pointAt(panelM);
        scene.idle(40);
        scene.overlay().showControls(panelM, Pointing.DOWN, 40).showing(AllIcons.I_ADD);
        scene.idle(50);
        scene.overlay().showControls(panelM.method_1031(1.0, -0.5, 0.0), Pointing.DOWN, 50).rightClick();
        scene.idle(7);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, nuggG, boundingBox.method_989(1.0, -0.5, 0.0), 40);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, alloyG, boundingBox, 40);
        scene.idle(10);
        FactoryGaugeScenes.addPanelConnection(builder, alloyG, PanelSlot.BOTTOM_LEFT, nuggG, PanelSlot.TOP_LEFT);
        FactoryGaugeScenes.setArrowMode(builder, alloyG, PanelSlot.BOTTOM_LEFT, nuggG, PanelSlot.TOP_LEFT, 1);
        scene.idle(45);
        scene.overlay().showControls(panelM, Pointing.DOWN, 40).showing(AllIcons.I_ADD);
        scene.idle(50);
        scene.overlay().showControls(panelM.method_1031(1.0, 0.0, 0.0), Pointing.DOWN, 50).rightClick();
        scene.idle(7);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, andeG, boundingBox.method_989(1.0, 0.0, 0.0), 40);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, alloyG, boundingBox, 40);
        scene.idle(10);
        FactoryGaugeScenes.addPanelConnection(builder, alloyG, PanelSlot.BOTTOM_LEFT, andeG, PanelSlot.BOTTOM_LEFT);
        scene.idle(45);
        scene.overlay().showText(70).text("For aesthetics, input panels can be wrenched to change the pathing").colored(PonderPalette.BLUE).attachKeyFrame().placeNearTarget().pointAt(panelM.method_1031(1.0, -0.5, 0.0));
        scene.idle(80);
        scene.overlay().showControls(panelM.method_1031(1.125, -0.5, 0.0), Pointing.RIGHT, 50).rightClick().withItem(AllItems.WRENCH.method_7854());
        scene.idle(7);
        FactoryGaugeScenes.setArrowMode(builder, alloyG, PanelSlot.BOTTOM_LEFT, nuggG, PanelSlot.TOP_LEFT, 2);
        scene.idle(60);
        scene.overlay().showControls(panelM, Pointing.DOWN, 100).rightClick();
        scene.idle(7);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.BLUE, alloyG, boundingBox, 100);
        scene.overlay().showText(110).text("In the UI, review the inputs and specify how much of the output gets made per batch").attachKeyFrame().placeNearTarget().pointAt(panelM);
        scene.idle(120);
        scene.overlay().showText(80).text("Specify the address that ingredients should be sent to").attachKeyFrame().placeNearTarget().pointAt(panelM);
        scene.idle(70);
        scene.world().showSection(belt1, class_2350.field_11033);
        scene.idle(1);
        scene.world().setBlocks(util.select().fromTo(1, 6, 7, 1, 6, 2), class_2246.field_10124.method_9564(), false);
        scene.idle(3);
        scene.world().showSection(belt2, class_2350.field_11033);
        scene.idle(1);
        scene.world().setBlocks(util.select().fromTo(1, 6, 1, 3, 6, 1), class_2246.field_10124.method_9564(), false);
        scene.idle(3);
        scene.world().showSection(saw, class_2350.field_11033);
        scene.idle(1);
        scene.world().setBlocks(util.select().position(4, 6, 1), class_2246.field_10124.method_9564(), false);
        scene.idle(3);
        scene.world().showSection(belt3, class_2350.field_11033);
        scene.idle(1);
        scene.world().setBlocks(util.select().fromTo(5, 6, 1, 6, 6, 1), class_2246.field_10124.method_9564(), false);
        scene.idle(20);
        scene.overlay().showControls(panelM, Pointing.DOWN, 100).rightClick();
        scene.idle(7);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, alloyG, boundingBox, 100);
        scene.overlay().showText(100).text("The target amount to maintain can now be set by holding Right-click on the gauge").attachKeyFrame().colored(PonderPalette.GREEN).placeNearTarget().pointAt(panelM);
        scene.idle(110);
        FactoryGaugeScenes.setPanelNotSatisfied(builder, alloyG, PanelSlot.BOTTOM_LEFT);
        scene.idle(20);
        scene.overlay().showOutlineWithText(vault, 80).text("Whenever the network has fewer items than the amount...").colored(PonderPalette.BLUE).attachKeyFrame().placeNearTarget().pointAt(util.vector().of(4.0, 3.0, 7.0));
        scene.idle(90);
        PonderHilo.linkEffect(scene, link);
        class_1799 andesiteItem = new class_1799((class_1935)class_1802.field_20407);
        class_1799 nuggetItem = new class_1799((class_1935)class_1802.field_8675);
        class_1799 box = PackageItem.containing(List.of(andesiteItem, nuggetItem));
        PonderHilo.packagerCreate(scene, pack, box);
        FactoryGaugeScenes.flash(builder, alloyG, PanelSlot.BOTTOM_LEFT);
        scene.idle(20);
        scene.overlay().showText(70).text("...it will send new ingredients to the specified address").colored(PonderPalette.BLUE).placeNearTarget().attachKeyFrame().pointAt(util.vector().blockSurface(pack, class_2350.field_11039));
        scene.idle(80);
        scene.world().showSection(funnel1, class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(funnel2, class_2350.field_11033);
        scene.idle(10);
        scene.world().createItemOnBelt(util.grid().at(1, 0, 7), class_2350.field_11034, box);
        class_2338 sawPos = util.grid().at(4, 0, 1);
        PonderHilo.packagerClear(scene, pack);
        scene.idle(56);
        scene.world().modifyBlockEntity(sawPos, SawBlockEntity.class, be -> {
            ProcessingInventory inventory = be.inventory;
            inventory.recipeDuration = 10.0f;
            inventory.remainingTime = 10.0f;
            inventory.appliedRecipe = false;
        });
        scene.idle(2);
        scene.world().modifyBlockEntity(sawPos, SawBlockEntity.class, be -> {
            ProcessingInventory inventory = be.inventory;
            inventory.method_5447(0, class_1799.field_8037);
            inventory.method_5447(1, andesiteItem);
            inventory.method_5447(2, nuggetItem);
            inventory.recipeDuration = 20.0f;
            inventory.remainingTime = 20.0f;
            inventory.appliedRecipe = true;
        });
        scene.idle(6);
        scene.world().modifyBlockEntity(sawPos, SawBlockEntity.class, be -> {
            ProcessingInventory inventory = be.inventory;
            inventory.method_5447(1, class_1799.field_8037);
            DirectBeltInputBehaviour behaviour = BlockEntityBehaviour.get((class_1922)be.method_10997(), util.grid().at(5, 0, 1), DirectBeltInputBehaviour.TYPE);
            behaviour.handleInsertion(andesiteItem, class_2350.field_11034, false);
        });
        scene.idle(8);
        scene.world().modifyBlockEntity(sawPos, SawBlockEntity.class, be -> {
            ProcessingInventory inventory = be.inventory;
            inventory.method_5447(2, class_1799.field_8037);
            DirectBeltInputBehaviour behaviour = BlockEntityBehaviour.get((class_1922)be.method_10997(), util.grid().at(5, 0, 1), DirectBeltInputBehaviour.TYPE);
            behaviour.handleInsertion(nuggetItem, class_2350.field_11034, false);
        });
        scene.idle(3);
        scene.world().removeItemsFromBelt(util.grid().at(6, 0, 1));
        scene.world().flapFunnel(util.grid().at(6, 1, 1), false);
        scene.idle(8);
        scene.world().removeItemsFromBelt(util.grid().at(6, 0, 1));
        scene.world().flapFunnel(util.grid().at(6, 1, 1), false);
        scene.idle(5);
        Class<MechanicalMixerBlockEntity> type = MechanicalMixerBlockEntity.class;
        scene.world().modifyBlockEntity(util.grid().at(7, 3, 1), type, MechanicalMixerBlockEntity::startProcessingBasin);
        scene.world().createItemOnBeltLike(util.grid().at(7, 1, 1), class_2350.field_11036, andesiteItem);
        scene.world().createItemOnBeltLike(util.grid().at(7, 1, 1), class_2350.field_11036, nuggetItem);
        scene.idle(20);
        scene.world().showSection(basinOut, class_2350.field_11033);
        scene.idle(1);
        scene.world().setBlocks(util.select().fromTo(7, 6, 2, 7, 6, 3), class_2246.field_10124.method_9564(), false);
        scene.world().showSection(barrelAndPackager, class_2350.field_11033);
        scene.idle(20);
        scene.world().modifyBlockEntityNBT(basin, BasinBlockEntity.class, nbt -> {
            class_6903 ops = builder.world().getHolderLookupProvider().method_57093((DynamicOps)class_2509.field_11560);
            class_2499 list = new class_2499();
            list.add((Object)((class_2520)class_1799.field_24671.encodeStart((DynamicOps)ops, (Object)AllItems.ANDESITE_ALLOY.method_7854()).getOrThrow()));
            nbt.method_10566("VisualizedItems", (class_2520)list);
        });
        scene.idle(4);
        scene.rotateCameraY(90.0f);
        scene.idle(40);
        scene.overlay().showText(90).text("The outputs then need to return to any of the linked inventories").colored(PonderPalette.BLUE).placeNearTarget().attachKeyFrame().pointAt(util.vector().blockSurface(util.grid().at(7, 1, 3), class_2350.field_11036));
        scene.idle(70);
        scene.world().showSection(belt4, class_2350.field_11033);
        scene.idle(1);
        scene.world().setBlocks(util.select().fromTo(7, 6, 5, 7, 6, 7), class_2246.field_10124.method_9564(), false);
        scene.world().showSection(pack2S, class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(funnel3, class_2350.field_11033);
        scene.idle(10);
        scene.world().toggleRedstonePower(util.select().fromTo(7, 1, 4, 7, 2, 4));
        scene.effects().indicateRedstone(util.grid().at(7, 2, 4));
        class_1799 box2 = PackageItem.containing(List.of());
        PonderHilo.packagerCreate(scene, util.grid().at(7, 1, 4), box2);
        scene.idle(20);
        PonderHilo.packagerClear(scene, util.grid().at(7, 1, 4));
        scene.world().createItemOnBelt(util.grid().at(7, 0, 5), class_2350.field_11043, box2);
        scene.idle(35);
        scene.world().removeItemsFromBelt(util.grid().at(7, 0, 7));
        scene.world().flapFunnel(util.grid().at(7, 1, 7), false);
        PonderHilo.packagerUnpack(scene, util.grid().at(6, 1, 7), box2);
        scene.idle(20);
        FactoryGaugeScenes.setPanelSatisfied(scene, alloyG, PanelSlot.BOTTOM_LEFT);
        scene.rotateCameraY(-90.0f);
        scene.idle(40);
        scene.overlay().showText(110).text("Green connections indicate that the target amount has been reached").attachKeyFrame().colored(PonderPalette.GREEN).placeNearTarget().pointAt(panelM.method_1031(0.5, 0.0, 0.0));
        scene.idle(120);
        scene.world().hideSection(mixer, class_2350.field_11034);
        scene.world().hideSection(basin, class_2350.field_11034);
        scene.world().hideSection(basinOut, class_2350.field_11036);
        scene.idle(3);
        scene.world().hideSection(barrelAndPackager, class_2350.field_11034);
        scene.world().hideSection(funnel1, class_2350.field_11036);
        scene.world().hideSection(util.select().position(6, 1, 1), class_2350.field_11036);
        scene.world().hideSection(util.select().position(7, 1, 5), class_2350.field_11036);
        scene.world().hideSection(util.select().fromTo(6, 0, 1, 1, 0, 1), class_2350.field_11033);
        scene.world().hideSection(util.select().fromTo(1, 0, 7, 1, 0, 2), class_2350.field_11033);
        scene.idle(5);
        scene.world().restoreBlocks(util.select().fromTo(6, 6, 1, 1, 6, 1));
        scene.world().restoreBlocks(util.select().fromTo(1, 6, 7, 1, 6, 2));
        scene.world().restoreBlocks(util.select().fromTo(7, 6, 4, 7, 6, 1));
        scene.idle(15);
        scene.world().showSection(scaff2, class_2350.field_11033);
        ElementLink<WorldSectionElement> scaffL = scene.world().showIndependentSection(scaff2, class_2350.field_11033);
        scene.world().moveSection(scaffL, util.vector().of(4.0, 0.0, 0.0), 0);
        scene.idle(10);
        scene.world().showSection(board2, class_2350.field_11033);
        scene.idle(10);
        FactoryGaugeScenes.setPanelPassive(builder, ironG, PanelSlot.TOP_LEFT);
        FactoryGaugeScenes.removePanelConnections(builder, ironG, PanelSlot.TOP_LEFT);
        scene.world().showSection(util.select().position(ironG), class_2350.field_11035);
        scene.idle(15);
        FactoryGaugeScenes.addPanelConnection(builder, nuggG, PanelSlot.TOP_LEFT, ironG, PanelSlot.TOP_LEFT);
        FactoryGaugeScenes.setPanelNotSatisfied(builder, nuggG, PanelSlot.TOP_LEFT);
        scene.idle(15);
        scene.overlay().showText(110).text("The board of gauges can expand to include more recipe steps").attachKeyFrame().colored(PonderPalette.BLUE).placeNearTarget().pointAt(panelM.method_1031(1.0, -0.5, 0.0));
        scene.idle(120);
        FactoryGaugeScenes.setPanelPassive(builder, dioriteG, PanelSlot.TOP_LEFT);
        FactoryGaugeScenes.removePanelConnections(builder, dioriteG, PanelSlot.TOP_LEFT);
        scene.world().showSection(util.select().position(dioriteG), class_2350.field_11035);
        scene.idle(5);
        FactoryGaugeScenes.setPanelPassive(builder, cobbleG, PanelSlot.TOP_LEFT);
        FactoryGaugeScenes.removePanelConnections(builder, cobbleG, PanelSlot.TOP_LEFT);
        scene.world().showSection(util.select().position(cobbleG), class_2350.field_11035);
        scene.idle(10);
        FactoryGaugeScenes.addPanelConnection(builder, andeG, PanelSlot.BOTTOM_LEFT, dioriteG, PanelSlot.TOP_LEFT);
        FactoryGaugeScenes.setPanelNotSatisfied(builder, andeG, PanelSlot.BOTTOM_LEFT);
        scene.idle(5);
        FactoryGaugeScenes.addPanelConnection(builder, andeG, PanelSlot.BOTTOM_LEFT, cobbleG, PanelSlot.TOP_LEFT);
        FactoryGaugeScenes.setArrowMode(builder, andeG, PanelSlot.BOTTOM_LEFT, cobbleG, PanelSlot.TOP_LEFT, 2);
        FactoryGaugeScenes.setPanelNotSatisfied(builder, andeG, PanelSlot.BOTTOM_LEFT);
        scene.idle(15);
        FactoryGaugeScenes.removePanelConnections(builder, quartzG, PanelSlot.BOTTOM_RIGHT);
        FactoryGaugeScenes.removePanelConnections(builder, logsG, PanelSlot.TOP_LEFT);
        FactoryGaugeScenes.removePanelConnections(builder, alloyG, PanelSlot.TOP_RIGHT);
        FactoryGaugeScenes.removePanelConnections(builder, logsG, PanelSlot.BOTTOM_RIGHT);
        FactoryGaugeScenes.removePanelConnections(builder, planksG, PanelSlot.BOTTOM_RIGHT);
        FactoryGaugeScenes.removePanelConnections(builder, rawIronG, PanelSlot.BOTTOM_RIGHT);
        FactoryGaugeScenes.removePanelConnections(builder, cogG, PanelSlot.TOP_LEFT);
        scene.overlay().showText(110).text("Each gauge maintains the stock level of its item independently").attachKeyFrame().colored(PonderPalette.BLUE).placeNearTarget().pointAt(panelM.method_1031(1.0, 0.0, 0.0));
        scene.idle(120);
        FactoryGaugeScenes.setPanelPassive(builder, quartzG, PanelSlot.BOTTOM_RIGHT);
        scene.world().showSection(util.select().position(quartzG), class_2350.field_11035);
        scene.idle(15);
        FactoryGaugeScenes.addPanelConnection(builder, dioriteG, PanelSlot.TOP_LEFT, quartzG, PanelSlot.BOTTOM_RIGHT);
        FactoryGaugeScenes.addPanelConnection(builder, dioriteG, PanelSlot.TOP_LEFT, cobbleG, PanelSlot.TOP_LEFT);
        FactoryGaugeScenes.setPanelNotSatisfied(builder, dioriteG, PanelSlot.TOP_LEFT);
        scene.idle(5);
        scene.world().showSection(util.select().position(logsG), class_2350.field_11035);
        scene.idle(10);
        scene.world().showSection(util.select().position(rawIronG), class_2350.field_11035);
        scene.idle(4);
        FactoryGaugeScenes.setPanelVisible(builder, alloyG, PanelSlot.TOP_RIGHT, true);
        scene.idle(1);
        FactoryGaugeScenes.addPanelConnection(builder, logsG, PanelSlot.BOTTOM_RIGHT, logsG, PanelSlot.TOP_LEFT);
        FactoryGaugeScenes.setPanelNotSatisfied(builder, logsG, PanelSlot.BOTTOM_RIGHT);
        scene.world().showSection(util.select().position(planksG), class_2350.field_11035);
        scene.idle(5);
        scene.world().showSection(util.select().position(cogG), class_2350.field_11035);
        FactoryGaugeScenes.addPanelConnection(builder, alloyG, PanelSlot.TOP_RIGHT, alloyG, PanelSlot.BOTTOM_LEFT);
        FactoryGaugeScenes.setPanelNotSatisfied(builder, alloyG, PanelSlot.TOP_RIGHT);
        scene.idle(5);
        FactoryGaugeScenes.addPanelConnection(builder, ironG, PanelSlot.TOP_LEFT, rawIronG, PanelSlot.BOTTOM_RIGHT);
        FactoryGaugeScenes.setPanelNotSatisfied(builder, ironG, PanelSlot.TOP_LEFT);
        scene.idle(5);
        FactoryGaugeScenes.addPanelConnection(builder, planksG, PanelSlot.BOTTOM_RIGHT, logsG, PanelSlot.BOTTOM_RIGHT);
        FactoryGaugeScenes.setPanelNotSatisfied(builder, planksG, PanelSlot.BOTTOM_RIGHT);
        scene.idle(5);
        FactoryGaugeScenes.addPanelConnection(builder, cogG, PanelSlot.TOP_LEFT, planksG, PanelSlot.BOTTOM_RIGHT);
        FactoryGaugeScenes.addPanelConnection(builder, cogG, PanelSlot.TOP_LEFT, alloyG, PanelSlot.TOP_RIGHT);
        FactoryGaugeScenes.setPanelNotSatisfied(builder, cogG, PanelSlot.TOP_LEFT);
    }

    public static void crafting(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("factory_gauge_crafting", "Automatic Crafting with Factory Gauges");
        scene.configureBasePlate(0, 0, 9);
        scene.scaleSceneView(0.925f);
        scene.setSceneOffsetY(-0.5f);
        scene.showBasePlate();
        Selection scaff = util.select().fromTo(3, 1, 5, 1, 1, 5);
        Selection board = util.select().fromTo(3, 2, 5, 1, 3, 5);
        FactoryPanelPosition pickG = new FactoryPanelPosition(util.grid().at(1, 3, 4), PanelSlot.BOTTOM_LEFT);
        FactoryPanelPosition stickG = new FactoryPanelPosition(util.grid().at(2, 2, 4), PanelSlot.TOP_LEFT);
        FactoryPanelPosition diaG = new FactoryPanelPosition(util.grid().at(3, 3, 4), PanelSlot.BOTTOM_RIGHT);
        class_2338 funnelToDelete = util.grid().at(1, 2, 1);
        scene.world().setBlock(funnelToDelete, class_2246.field_10124.method_9564(), false);
        Selection belt1 = util.select().fromTo(0, 1, 1, 7, 1, 1);
        Selection belt2 = util.select().fromTo(7, 1, 7, 0, 1, 7);
        Selection repacker = util.select().fromTo(1, 2, 1, 4, 3, 1);
        Selection crafterBits = util.select().fromTo(6, 1, 3, 7, 1, 3);
        Selection crafter = util.select().fromTo(6, 1, 2, 6, 4, 4).substract(crafterBits);
        class_2338 pack = util.grid().at(6, 2, 1);
        Selection packS = util.select().position(6, 2, 1);
        Selection cogs1 = util.select().fromTo(7, 1, 2, 8, 1, 2);
        Selection cogs2 = util.select().fromTo(7, 1, 6, 8, 1, 6);
        Selection largeCog1 = util.select().position(9, 0, 2);
        Selection largeCog2 = util.select().position(9, 0, 6);
        Selection barrel = util.select().fromTo(6, 1, 5, 6, 2, 5);
        Selection outPacker = util.select().fromTo(6, 1, 6, 6, 3, 6).add(util.select().position(5, 2, 6));
        Selection outFunnel = util.select().position(6, 2, 7);
        scene.idle(10);
        scene.world().showSection(scaff, class_2350.field_11043);
        scene.world().showSection(board, class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(crafterBits, class_2350.field_11039);
        scene.world().showSection(largeCog1, class_2350.field_11036);
        scene.world().showSection(cogs1, class_2350.field_11035);
        scene.idle(5);
        scene.world().showSection(crafter, class_2350.field_11033);
        scene.idle(15);
        scene.overlay().showText(100).text("Factory gauges provide auto-arrangement for crafting table recipes").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(6, 3, 3), class_2350.field_11039));
        scene.idle(110);
        FactoryGaugeScenes.removePanelConnections(builder, pickG.pos(), pickG.slot());
        FactoryGaugeScenes.setPanelPassive(builder, pickG.pos(), pickG.slot());
        scene.world().showSection(util.select().position(diaG.pos()), class_2350.field_11035);
        scene.idle(5);
        scene.world().showSection(util.select().position(stickG.pos()), class_2350.field_11035);
        scene.idle(5);
        scene.world().showSection(util.select().position(pickG.pos()), class_2350.field_11035);
        scene.idle(15);
        FactoryGaugeScenes.addPanelConnection(builder, pickG.pos(), pickG.slot(), diaG.pos(), diaG.slot());
        scene.idle(5);
        FactoryGaugeScenes.addPanelConnection(builder, pickG.pos(), pickG.slot(), stickG.pos(), stickG.slot());
        scene.idle(5);
        class_243 midl = util.vector().of(1.75, 3.25, 5.0);
        scene.overlay().showText(60).text("Connect the required ingredients as before").attachKeyFrame().placeNearTarget().pointAt(midl);
        scene.idle(80);
        scene.overlay().showControls(midl, Pointing.DOWN, 120).showing(AllIcons.I_3x3);
        scene.idle(7);
        class_238 boundingBox = new class_238(midl, midl).method_1009(0.19, 0.19, 0.0);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.BLUE, pickG, boundingBox, 100);
        scene.idle(10);
        scene.overlay().showText(90).text("When a valid recipe is detected, a new button appears in the UI").attachKeyFrame().colored(PonderPalette.BLUE).placeNearTarget().pointAt(midl);
        scene.idle(100);
        scene.world().showSection(belt1, class_2350.field_11035);
        scene.world().showSection(packS, class_2350.field_11033);
        scene.idle(30);
        scene.overlay().showText(120).text("With auto-arrangement active, the boxes can be unwrapped into crafters directly").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(6, 2, 1), class_2350.field_11039));
        scene.idle(130);
        scene.rotateCameraY(90.0f);
        scene.idle(40);
        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(6, 3, 4), class_2350.field_11034), Pointing.RIGHT, 120).rightClick().withItem(AllItems.WRENCH.method_7854());
        scene.idle(7);
        scene.world().connectCrafterInvs(util.grid().at(6, 4, 4), util.grid().at(6, 4, 3));
        scene.world().connectCrafterInvs(util.grid().at(6, 4, 3), util.grid().at(6, 4, 2));
        scene.world().connectCrafterInvs(util.grid().at(6, 4, 4), util.grid().at(6, 3, 4));
        scene.world().connectCrafterInvs(util.grid().at(6, 4, 3), util.grid().at(6, 3, 3));
        scene.world().connectCrafterInvs(util.grid().at(6, 4, 2), util.grid().at(6, 3, 2));
        scene.world().connectCrafterInvs(util.grid().at(6, 3, 4), util.grid().at(6, 2, 4));
        scene.world().connectCrafterInvs(util.grid().at(6, 3, 3), util.grid().at(6, 2, 3));
        scene.world().connectCrafterInvs(util.grid().at(6, 3, 2), util.grid().at(6, 2, 2));
        for (int y = 0; y < 3; ++y) {
            for (int z = 0; z < 3; ++z) {
                scene.effects().indicateSuccess(util.grid().at(6, 2 + y, 2 + z));
            }
        }
        scene.idle(20);
        scene.overlay().showOutlineWithText(util.select().fromTo(6, 2, 2, 6, 4, 4), 100).text("The setup must be 3x3 and the crafters have to be connected via wrench").attachKeyFrame().colored(PonderPalette.GREEN).placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(6, 3, 2), class_2350.field_11043));
        scene.idle(100);
        scene.rotateCameraY(-90.0f);
        scene.idle(20);
        scene.world().showSection(util.select().position(5, 2, 1), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(barrel, class_2350.field_11043);
        scene.idle(20);
        scene.overlay().showControls(midl, Pointing.DOWN, 60).rightClick();
        scene.idle(7);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, pickG, boundingBox, 100);
        scene.overlay().showText(60).text("Hold Right-click on the gauge to set the target amount").attachKeyFrame().colored(PonderPalette.GREEN).placeNearTarget().pointAt(midl);
        scene.idle(70);
        FactoryGaugeScenes.setPanelNotSatisfied(builder, pickG.pos(), pickG.slot());
        scene.idle(10);
        class_1799 box = PackageItem.containing(List.of());
        scene.world().createItemOnBelt(util.grid().at(0, 1, 1), class_2350.field_11039, box);
        scene.idle(40);
        scene.world().removeItemsFromBelt(util.grid().at(5, 1, 1));
        scene.world().flapFunnel(util.grid().at(5, 2, 1), false);
        PonderHilo.packagerUnpack(scene, pack, box);
        scene.rotateCameraY(-15.0f);
        scene.idle(15);
        FactoryGaugeScenes.insertItemsIntoCrafter(scene, util.grid().at(6, 4, 2), new class_1799((class_1935)class_1802.field_8477));
        FactoryGaugeScenes.insertItemsIntoCrafter(scene, util.grid().at(6, 4, 3), new class_1799((class_1935)class_1802.field_8477));
        FactoryGaugeScenes.insertItemsIntoCrafter(scene, util.grid().at(6, 4, 4), new class_1799((class_1935)class_1802.field_8477));
        FactoryGaugeScenes.insertItemsIntoCrafter(scene, util.grid().at(6, 3, 3), new class_1799((class_1935)class_1802.field_8600));
        FactoryGaugeScenes.insertItemsIntoCrafter(scene, util.grid().at(6, 2, 3), new class_1799((class_1935)class_1802.field_8600));
        scene.world().setCraftingResult(util.grid().at(6, 2, 4), new class_1799((class_1935)class_1802.field_8377));
        scene.world().modifyBlockEntity(util.grid().at(6, 3, 2), MechanicalCrafterBlockEntity.class, be -> be.checkCompletedRecipe(true));
        scene.idle(60);
        scene.overlay().showText(120).text("This crafter can now be used universally, by more gauges with different recipes").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(6, 3, 4), class_2350.field_11039));
        scene.idle(120);
        scene.world().showSection(outPacker, class_2350.field_11043);
        scene.idle(20);
        scene.rotateCameraY(15.0f);
        scene.world().toggleRedstonePower(util.select().fromTo(6, 2, 6, 6, 3, 6));
        scene.effects().indicateRedstone(util.grid().at(6, 3, 6));
        scene.world().showSection(belt2, class_2350.field_11043);
        scene.world().showSection(outFunnel, class_2350.field_11033);
        scene.world().showSection(largeCog2, class_2350.field_11036);
        scene.world().showSection(cogs2, class_2350.field_11039);
        scene.world().restoreBlocks(util.select().position(funnelToDelete));
        scene.idle(15);
        class_1799 box2 = PackageItem.containing(List.of());
        PonderHilo.packagerCreate(scene, util.grid().at(6, 2, 6), box2);
        scene.idle(20);
        PonderHilo.packagerClear(scene, util.grid().at(6, 2, 6));
        scene.world().createItemOnBelt(util.grid().at(6, 1, 7), class_2350.field_11043, box2);
        scene.overlay().showText(100).text("Outputs should be sent back to a linked inventory to close the loop").attachKeyFrame().colored(PonderPalette.BLUE).placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(6, 2, 6), class_2350.field_11039));
        scene.idle(48);
        PonderHilo.packageHopsOffBelt(scene, util.grid().at(0, 1, 7), class_2350.field_11039, box2);
        scene.idle(50);
        scene.world().showSection(repacker, class_2350.field_11033);
        scene.idle(20);
        scene.overlay().showText(120).text("Using a Re-packager is recommended to prevent fragmentation of input packages").attachKeyFrame().colored(PonderPalette.BLUE).placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(3, 2, 1), class_2350.field_11043));
        scene.idle(120);
    }

    public static void links(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("factory_gauge_links", "Connecting Gauges to other Blocks");
        scene.setSceneOffsetY(-1.0f);
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        Selection scaff = util.select().fromTo(3, 1, 2, 1, 1, 2);
        Selection board = util.select().fromTo(3, 3, 2, 1, 2, 2);
        class_2338 link = util.grid().at(3, 2, 1);
        class_2338 display = util.grid().at(1, 2, 1);
        class_2338 gauge = util.grid().at(2, 3, 1);
        Selection linkS = util.select().position(3, 2, 1);
        Selection displayS = util.select().position(1, 2, 1);
        Selection gaugeS = util.select().position(2, 3, 1);
        PanelSlot slot = PanelSlot.TOP_LEFT;
        FactoryGaugeScenes.removePanelConnections(scene, gauge, slot);
        scene.idle(10);
        scene.world().showSection(scaff, class_2350.field_11043);
        scene.world().showSection(board, class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(gaugeS, class_2350.field_11035);
        scene.idle(20);
        class_243 midl = util.vector().of(2.75, 3.75, 2.0);
        class_238 boundingBox = new class_238(midl, midl).method_1009(0.19, 0.19, 0.0);
        scene.overlay().showControls(midl, Pointing.DOWN, 60).showing(AllIcons.I_ADD);
        scene.idle(7);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.BLUE, gauge, boundingBox, 100);
        scene.idle(10);
        scene.overlay().showText(70).text("When adding a new connection from the UI...").attachKeyFrame().colored(PonderPalette.BLUE).placeNearTarget().pointAt(midl);
        scene.idle(50);
        scene.world().showSection(linkS, class_2350.field_11035);
        scene.idle(5);
        scene.world().showSection(displayS, class_2350.field_11035);
        scene.idle(30);
        scene.overlay().showControls(util.vector().of(4.0, 2.5, 2.0), Pointing.RIGHT, 60).rightClick();
        scene.idle(7);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, link, boundingBox.method_989(0.75, -1.25, 0.0).method_1009(0.15, 0.25, 0.0), 40);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, gauge, boundingBox, 40);
        FactoryGaugeScenes.addPanelConnection(builder, gauge, slot, link, PanelSlot.TOP_RIGHT);
        FactoryGaugeScenes.setArrowMode(builder, gauge, slot, link, PanelSlot.TOP_RIGHT, 0);
        scene.idle(20);
        scene.overlay().showText(70).text("...the gauge also accepts Redstone and Display Links").attachKeyFrame().colored(PonderPalette.BLUE).placeNearTarget().pointAt(midl.method_1031(0.5, -1.5, 0.0));
        scene.idle(80);
        FactoryGaugeScenes.setPanelSatisfied(builder, gauge, slot);
        scene.world().toggleRedstonePower(util.select().position(3, 2, 1));
        scene.effects().indicateRedstone(util.grid().at(3, 2, 1));
        scene.idle(40);
        scene.overlay().showText(120).text("Redstone links will be powered when the stock level is at or above the target amount").attachKeyFrame().placeNearTarget().pointAt(midl);
        scene.idle(130);
        scene.world().toggleRedstonePower(util.select().position(3, 2, 1));
        FactoryGaugeScenes.setPanelNotSatisfied(builder, gauge, slot);
        scene.idle(30);
        scene.overlay().showControls(util.vector().of(4.0, 2.5, 2.0), Pointing.RIGHT, 60).withItem(AllItems.WRENCH.method_7854()).rightClick();
        scene.idle(7);
        scene.world().cycleBlockProperty(util.grid().at(3, 2, 1), (class_2769<?>)RedstoneLinkBlock.RECEIVER);
        scene.idle(30);
        scene.world().toggleRedstonePower(util.select().position(3, 2, 1));
        scene.effects().indicateRedstone(util.grid().at(3, 2, 1));
        FactoryGaugeScenes.setPanelPowered(builder, gauge, slot, true);
        scene.idle(30);
        scene.overlay().showText(100).text("In receiver mode, links can stop the gauge from sending requests").attachKeyFrame().placeNearTarget().pointAt(midl);
        scene.idle(130);
        FactoryGaugeScenes.addPanelConnection(builder, gauge, slot, display, slot);
        FactoryGaugeScenes.setArrowMode(builder, gauge, slot, display, slot, 2);
        scene.overlay().showText(100).text("Display links can provide a status overview of connected gauges").attachKeyFrame().colored(PonderPalette.BLUE).placeNearTarget().pointAt(util.vector().of(1.0, 3.0, 1.0));
        scene.idle(100);
    }

    private static void setPanelItem(SceneBuilder builder, class_2338 gauge, PanelSlot slot, class_1799 item) {
        FactoryGaugeScenes.withGaugeDo(builder, gauge, slot, pb -> pb.setFilter(item));
    }

    private static void setPanelPowered(SceneBuilder builder, class_2338 gauge, PanelSlot slot, boolean power) {
        FactoryGaugeScenes.withGaugeDo(builder, gauge, slot, pb -> {
            pb.redstonePowered = power;
        });
    }

    private static void setPanelVisible(SceneBuilder builder, class_2338 gauge, PanelSlot slot, boolean visible) {
        FactoryGaugeScenes.withGaugeDo(builder, gauge, slot, pb -> {
            pb.active = visible;
        });
    }

    private static void setPanelNotSatisfied(SceneBuilder builder, class_2338 gauge, PanelSlot slot) {
        FactoryGaugeScenes.withGaugeDo(builder, gauge, slot, pb -> {
            pb.count = 2;
        });
    }

    private static void flash(SceneBuilder builder, class_2338 gauge, PanelSlot slot) {
        FactoryGaugeScenes.withGaugeDo(builder, gauge, slot, pb -> pb.bulb.setValue(1.0));
    }

    private static void setPanelSatisfied(SceneBuilder builder, class_2338 gauge, PanelSlot slot) {
        FactoryGaugeScenes.withGaugeDo(builder, gauge, slot, pb -> {
            pb.count = 1;
        });
    }

    private static void setPanelPassive(SceneBuilder builder, class_2338 gauge, PanelSlot slot) {
        FactoryGaugeScenes.withGaugeDo(builder, gauge, slot, pb -> {
            pb.count = 0;
        });
    }

    private static void removePanelConnections(SceneBuilder builder, class_2338 gauge, PanelSlot slot) {
        FactoryGaugeScenes.withGaugeDo(builder, gauge, slot, ServerFactoryPanelBehaviour::disconnectAll);
    }

    private static void setArrowMode(SceneBuilder builder, class_2338 gauge, PanelSlot slot, class_2338 fromGauge, PanelSlot fromSlot, int mode) {
        FactoryGaugeScenes.withGaugeDo(builder, gauge, slot, pb -> {
            FactoryPanelConnection connection = pb.targetedBy.get(new FactoryPanelPosition(fromGauge, fromSlot));
            if (connection == null && (connection = pb.targetedByLinks.get(fromGauge)) == null) {
                return;
            }
            connection.arrowBendMode = mode;
        });
    }

    private static void addPanelConnection(SceneBuilder builder, class_2338 gauge, PanelSlot slot, class_2338 fromGauge, PanelSlot fromSlot) {
        FactoryGaugeScenes.withGaugeDo(builder, gauge, slot, pb -> pb.addConnection(new FactoryPanelPosition(fromGauge, fromSlot)));
    }

    private static void insertItemsIntoCrafter(CreateSceneBuilder scene, class_2338 pos, class_1799 stack) {
        scene.world().modifyBlockEntity(pos, MechanicalCrafterBlockEntity.class, be -> be.getInventory().method_5447(0, stack));
    }

    private static void withGaugeDo(SceneBuilder builder, class_2338 gauge, PanelSlot slot, Consumer<ServerFactoryPanelBehaviour> call) {
        builder.world().modifyBlockEntity(gauge, FactoryPanelBlockEntity.class, be -> call.accept(be.panels.get((Object)slot)));
    }
}

